<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Offers extends Model 
{

    protected $table = 'offers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('generador_id', 'charge_id', 'dispatch_parking_id', 'delivery_parking_id', 'deadline_to_bid');
    protected $visible = array('generador_id', 'charge_id', 'dispatch_parking_id', 'delivery_parking_id', 'deadline_to_bid');

    public function offer_transporter()
    {
        return $this->hasMany('App\Transporter');
    }

    public function generator_offer()
    {
        return $this->hasMany('App\Generator');
    }

}