<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ratings extends Model 
{

    protected $table = 'ratings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('star', 'comments', 'driver_id', 'truck_id');

    public function truck()
    {
        return $this->belongsTo('App\Truck', 'truck_id');
    }

    public function driver()
    {
        return $this->belongsTo('App\Driver', 'driver_id');
    }

}