<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('generador_id')->unsigned();
			$table->integer('charge_id')->unsigned();
			$table->integer('dispatch_parking_id')->unsigned();
			$table->integer('delivery_parking_id')->unsigned();
			$table->date('deadline_to_bid');
			$table->integer('reference_cost_id')->unsigned();
			$table->integer('transporter_id')->unsigned();
			$table->integer('selected_transporter_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}