<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrucksTable extends Migration {

	public function up()
	{
		Schema::create('trucks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('mark', 70)->nullable();
			$table->string('model', 20);
			$table->string('plate', 10);
			$table->float('capacity');
			$table->string('year', 4);
			$table->integer('transporter_id')->unsigned()->nullable();
			$table->integer('axe_id')->unsigned()->nullable();
			$table->integer('truck_uses_id')->unsigned()->nullable();
			$table->integer('state_id')->unsigned()->nullable();
			$table->integer('truck_structure_id')->unsigned()->nullable();
			$table->string('image', 100)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('trucks');
	}
}