<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactusTable extends Migration {

	public function up()
	{
		Schema::create('contactus', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 150);
			$table->string('phone', 150);
			$table->text('content');
			$table->morphs('byable')->default('0');
			$table->string('country_code', 10);
		});
	}

	public function down()
	{
		Schema::drop('contactus');
	}
}