<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 100);
			$table->string('lat', 50);
			$table->string('lng', 50);
			$table->text('map_desc');
			$table->boolean('is_active')->default(0);
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}