<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function roles()
	{
		return $this->belongsToMany('App\Role');
	}

	public function users()
	{
		return $this->hasManyThrough('App\User');
	}

	public function permissions()
	{
		return $this->belongsToMany('App\Permission');
	}

	public function attempts()
	{
		return $this->hasMany('App\Login_attempts');
	}

}