<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('firstName');
			$table->string('lastName');
			$table->binary('gender')->nullable();
			$table->string('email');
			$table->string('password');
			$table->binary('isAdmin');
			$table->integer('notificationAllowed');
			$table->integer('mailAllowed');
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}