<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users_roles', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->foreign('roles_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_permissions', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_permissions', function(Blueprint $table) {
			$table->foreign('permissions_id')->references('id')->on('permissins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->foreign('permissions_id')->references('id')->on('permissins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->foreign('roles_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users_roles', function(Blueprint $table) {
			$table->dropForeign('users_roles_users_id_foreign');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->dropForeign('users_roles_roles_id_foreign');
		});
		Schema::table('users_permissions', function(Blueprint $table) {
			$table->dropForeign('users_permissions_users_id_foreign');
		});
		Schema::table('users_permissions', function(Blueprint $table) {
			$table->dropForeign('users_permissions_permissions_id_foreign');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->dropForeign('roles_permissions_permissions_id_foreign');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->dropForeign('roles_permissions_roles_id_foreign');
		});
	}
}