<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('Services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('type', 10);
			$table->string('service_code', 10);
			$table->integer('price');
			$table->integer('admin')->unsigned();
			$table->integer('payment_account_id')->unsigned();
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('Services');
	}
}