<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembersTable extends Migration {

	public function up()
	{
		Schema::create('members', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('team_id')->unsigned();
			$table->string('picture')->nullable();
			$table->date('birthdate')->nullable();
			$table->text('description')->nullable();
			$table->boolean('isPublic')->default(true);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('members');
	}
}