<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('recipes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('invitations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('applies', function(Blueprint $table) {
			$table->foreign('invitation_id')->references('id')->on('invitations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('applies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('nutritions', function(Blueprint $table) {
			$table->foreign('recipe_id')->references('id')->on('recipes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('category_recipe', function(Blueprint $table) {
			$table->foreign('recipe_id')->references('id')->on('recipes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('category_recipe', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('invitation_id')->references('id')->on('invitations')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ingredients', function(Blueprint $table) {
			$table->foreign('recipe_id')->references('id')->on('recipes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('preparations', function(Blueprint $table) {
			$table->foreign('recipe_id')->references('id')->on('recipes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('recipe_id')->references('id')->on('recipes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('recipe_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('recipe_tag', function(Blueprint $table) {
			$table->foreign('recipe_id')->references('id')->on('recipes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('recipe_images', function(Blueprint $table) {
			$table->foreign('recipe_id')->references('id')->on('recipes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->foreign('follower_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('profile', function(Blueprint $table) {
			$table->dropForeign('profile_user_id_foreign');
		});
		Schema::table('recipes', function(Blueprint $table) {
			$table->dropForeign('recipes_user_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_user_id_foreign');
		});
		Schema::table('invitations', function(Blueprint $table) {
			$table->dropForeign('invitations_user_id_foreign');
		});
		Schema::table('applies', function(Blueprint $table) {
			$table->dropForeign('applies_invitation_id_foreign');
		});
		Schema::table('applies', function(Blueprint $table) {
			$table->dropForeign('applies_user_id_foreign');
		});
		Schema::table('nutritions', function(Blueprint $table) {
			$table->dropForeign('nutritions_recipe_id_foreign');
		});
		Schema::table('category_recipe', function(Blueprint $table) {
			$table->dropForeign('category_recipe_recipe_id_foreign');
		});
		Schema::table('category_recipe', function(Blueprint $table) {
			$table->dropForeign('category_recipe_category_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_invitation_id_foreign');
		});
		Schema::table('ingredients', function(Blueprint $table) {
			$table->dropForeign('ingredients_recipe_id_foreign');
		});
		Schema::table('preparations', function(Blueprint $table) {
			$table->dropForeign('preparations_recipe_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_recipe_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('recipe_tag', function(Blueprint $table) {
			$table->dropForeign('recipe_tag_tag_id_foreign');
		});
		Schema::table('recipe_tag', function(Blueprint $table) {
			$table->dropForeign('recipe_tag_recipe_id_foreign');
		});
		Schema::table('recipe_images', function(Blueprint $table) {
			$table->dropForeign('recipe_images_recipe_id_foreign');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->dropForeign('followers_user_id_foreign');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->dropForeign('followers_follower_id_foreign');
		});
	}
}