<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserSoftSkillRatingTable extends Migration {

	public function up()
	{
		Schema::create('user_soft_skill_rating', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('soft_skill_id')->unsigned();
			$table->string('invitee_email')->index();
			$table->integer('no_of_stars')->nullable();
			$table->string('type')->index()->default('rated');
			$table->text('comment')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_soft_skill_rating');
	}
}