<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('soft_skill', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('soft_skill_360_invite', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_soft_skill', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_soft_skill', function(Blueprint $table) {
			$table->foreign('soft_skill_id')->references('id')->on('soft_skill')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_soft_skill_rating', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_soft_skill_rating', function(Blueprint $table) {
			$table->foreign('soft_skill_id')->references('id')->on('soft_skill')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('soft_skill', function(Blueprint $table) {
			$table->dropForeign('soft_skill_category_id_foreign');
		});
		Schema::table('soft_skill_360_invite', function(Blueprint $table) {
			$table->dropForeign('soft_skill_360_invite_user_id_foreign');
		});
		Schema::table('user_soft_skill', function(Blueprint $table) {
			$table->dropForeign('user_soft_skill_user_id_foreign');
		});
		Schema::table('user_soft_skill', function(Blueprint $table) {
			$table->dropForeign('user_soft_skill_soft_skill_id_foreign');
		});
		Schema::table('user_soft_skill_rating', function(Blueprint $table) {
			$table->dropForeign('user_soft_skill_rating_user_id_foreign');
		});
		Schema::table('user_soft_skill_rating', function(Blueprint $table) {
			$table->dropForeign('user_soft_skill_rating_soft_skill_id_foreign');
		});
	}
}