<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSoftSkill360InviteTable extends Migration {

	public function up()
	{
		Schema::create('soft_skill_360_invite', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('email');
			$table->string('relation')->nullable();
			$table->string('name')->nullable();
			$table->string('status')->nullable()->default('In Progress');
			$table->integer('invitee_user_id')->nullable()->index();
			$table->string('invitee_token');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('soft_skill_360_invite');
	}
}