<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEspacosTable extends Migration {

	public function up()
	{
		Schema::create('espacos', function(Blueprint $table) {
			$table->increments('id');
			$table->string('imagem');
			$table->string('nome');
			$table->string('descricao');
			$table->enum('tipo', array('privado', 'compartilhado'));
			$table->string('lotacao')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('espacos');
	}
}