<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->string('email', 50)->unique();
			$table->string('password', 50);
			$table->string('telephone', 20);
			$table->enum('role', array('null', 'client', 'provider', 'admin'));
			$table->integer('county_id');
			$table->integer('city_id');
			$table->string('profession', 50);
			$table->integer('age');
			$table->boolean('tc')->default(false);
			$table->text('about');
			$table->string('lat', 50);
			$table->string('lng', 50);
			$table->boolean('status')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}