<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('category_id');
			$table->string('name', 50);
			$table->text('description');
			$table->string('period', 100);
			$table->string('price', 50);
			$table->string('price_min', 50)->nullable();
			$table->string('price_max', 50)->nullable();
			$table->enum('type', array('fixed', 'interval'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}