<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('Company_id')->unsigned();
			$table->string('InvoiceMonth', 20);
			$table->string('PaymentIdentification', 255);
			$table->float('TotalAmount');
			$table->integer('ImportedByUser_id')->unsigned();
			$table->boolean('Validated')->default(0);
			$table->integer('ValidatedByUser_id')->unsigned();
			$table->integer('StatusInvoice_id')->unsigned();
			$table->binary('OriginalFile');
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}