<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('fire_trucks', function(Blueprint $table) {
			$table->foreign('fire_station_id')->references('id')->on('fire_stations')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('fire_trucks', function(Blueprint $table) {
			$table->foreign('fire_type_id')->references('id')->on('fire_truck_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('fire_trucks', function(Blueprint $table) {
			$table->dropForeign('fire_trucks_fire_station_id_foreign');
		});
		Schema::table('fire_trucks', function(Blueprint $table) {
			$table->dropForeign('fire_trucks_fire_type_id_foreign');
		});
	}
}