<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderOfferServiceTable extends Migration {

	public function up()
	{
		Schema::create('order_offer_service', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id');
			$table->bigInteger('provider_id');
			$table->bigInteger('user_id');
			$table->enum('status', array('1:pending', '2:accepted', '3:rejected'));
			$table->bigInteger('cancel_reason_id');
			$table->string('cancel_by')->default('user, provider');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_offer_service');
	}
}