<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartOrdersTable extends Migration {

	public function up()
	{
		Schema::create('cart_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('order_num');
			$table->integer('user_id')->unsigned();
			$table->integer('address_id')->unsigned();
			$table->decimal('sub_total', 10,2);
			$table->decimal('delivery_price', 10,2);
			$table->integer('coupon_id')->unsigned();
			$table->decimal('discount', 10,2);
			$table->decimal('vat', 10,2);
			$table->decimal('total', 10,2);
			$table->text('notes')->nullable();
			$table->string('status');
			$table->string('pay_type');
			$table->string('pay_status');
			$table->bigInteger('cancel_reason_id')->nullable();
			$table->string('cancel_by')->default('user, provider');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cart_orders');
	}
}