<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderServicesTable extends Migration {

	public function up()
	{
		Schema::create('order_services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('order_num', 50);
			$table->bigInteger('user_id');
			$table->bigInteger('provider_id')->nullable();
			$table->bigInteger('category_id');
			$table->bigInteger('sub_category_id');
			$table->string('description');
			$table->decimal('lat', 10, 8);
			$table->decimal('lng', 10, 8);
			$table->string('map_desc');
			$table->date('date');
			$table->time('time');
			$table->enum('status', array('1:new', '2:pending_accept_offer', '3:accept_offer', '4:current', '5:finished'));
			$table->tinyInteger('pay_type')->default('0');
			$table->tinyInteger('pay_status')->default('0');
			$table->json('pay_data')->nullable();
			$table->uuid('uuid');
			$table->bigInteger('cancel_reason_id')->nullable();
			$table->string('cancel_by')->default('user, provider');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_services');
	}
}