<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->bigInteger('base_category_id');
			$table->string('country_code', 5);
			$table->string('phone', 15);
			$table->bigInteger('city_id');
			$table->decimal('lat', 10, 8);
			$table->decimal('lng', 10, 8);
			$table->string('map_desc');
			$table->boolean('is_active')->default(0);
			$table->boolean('is_blocked')->default(0);
			$table->boolean('is_available')->default(0);
			$table->enum('is_approved', array('1:pending', '2:accepted', '3:rejected'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}