<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('cart_items', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart_items', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart_items', function(Blueprint $table) {
			$table->foreign('product_features_id')->references('id')->on('product_features')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart_orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart_orders', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart_orders', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('cart_order_id')->references('id')->on('cart_orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('product_features_id')->references('id')->on('product_features')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('cart_items', function(Blueprint $table) {
			$table->dropForeign('cart_items_user_id_foreign');
		});
		Schema::table('cart_items', function(Blueprint $table) {
			$table->dropForeign('cart_items_provider_id_foreign');
		});
		Schema::table('cart_items', function(Blueprint $table) {
			$table->dropForeign('cart_items_product_features_id_foreign');
		});
		Schema::table('cart_orders', function(Blueprint $table) {
			$table->dropForeign('cart_orders_user_id_foreign');
		});
		Schema::table('cart_orders', function(Blueprint $table) {
			$table->dropForeign('cart_orders_address_id_foreign');
		});
		Schema::table('cart_orders', function(Blueprint $table) {
			$table->dropForeign('cart_orders_coupon_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_cart_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_product_features_id_foreign');
		});
	}
}