<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblSettingEquipmentCategoryTable extends Migration {

	public function up()
	{
		Schema::create('tbl_setting_equipment_category', function(Blueprint $table) {
			$table->increments('equipment_category_id', true);
			$table->integer('equipment_category_priority')->default('0');
			$table->string('equipment_category_name', 100);
			$table->text('equipment_category_description')->nullable();
			$table->enum('equipment_category_status', array('Active', 'Inactive'));
			$table->datetime('equipment_category_created');
			$table->datetime('equipment_category_updated');
			$table->datetime('equipment_category_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_setting_equipment_category');
	}
}