<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblSettingParticularTable extends Migration {

	public function up()
	{
		Schema::create('tbl_setting_particular', function(Blueprint $table) {
			$table->increments('particular_id', true);
			$table->integer('particular_priority');
			$table->integer('particular_category_id')->unsigned();
			$table->string('particular_name', 100);
			$table->text('particular_description')->nullable();
			$table->enum('particular_format', array('Integer', 'Number', 'Text', 'Textarea', 'Select', 'Checkbox', 'Date'));
			$table->tinyInteger('is_required_value')->default('0');
			$table->tinyInteger('is_display_name')->default('0');
			$table->json('particular_properties')->nullable();
			$table->string('particular_prefix', 45)->nullable();
			$table->string('particular_postfix', 45)->nullable();
			$table->text('particular_remark')->nullable();
			$table->enum('particular_status', array('Active', 'Inactive'));
			$table->datetime('particular_created');
			$table->datetime('particular_updated');
			$table->datetime('particular_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_setting_particular');
	}
}