<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFinanceTable extends Migration {

	public function up()
	{
		Schema::create('finance', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_propriete')->unsigned();
			$table->string('location', 100);
			$table->string('type_paiement', 100);
			$table->string('autre_type', 100);
			$table->date('date_paiement');
			$table->integer('montant');
			$table->string('statut', 100);
			$table->boolean('imputer');
			$table->date('date_debut');
			$table->string('commentaire', 255);
			$table->integer('id_paiement')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('finance');
	}
}