<?php

namespace App/Models/backend/Book;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Book extends Eloquent {

	protected $table = 'books';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function publicationHose()
	{
		return $this->belongsTo('PublishingHouse');
	}

	public function author()
	{
		return $this->belongsTo('Author');
	}

	public function categories()
	{
		return $this->belongsToMany('Category');
	}

}