<?php

namespace App/Models/backend/BookCopy;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BookCopy extends Eloquent {

	protected $table = 'book_copies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function book()
	{
		return $this->belongsTo('App/Models/backend/Book\Book', 'book_id');
	}

	public function publicationHose()
	{
		return $this->belongsTo('PublishingHouse');
	}

	public function author()
	{
		return $this->belongsTo('Author');
	}

	public function categories()
	{
		return $this->belongsToMany('Category');
	}

}