<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('books', function(Blueprint $table) {
			$table->foreign('pub_house_id')->references('id')->on('pub_houses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('books', function(Blueprint $table) {
			$table->foreign('auther_id')->references('id')->on('authors')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('books', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cupboards', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('shelves', function(Blueprint $table) {
			$table->foreign('cupboard_id')->references('id')->on('cupboards')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('book_copies', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('authors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_copies', function(Blueprint $table) {
			$table->foreign('pub_house_id')->references('id')->on('pub_houses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('book_copies', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('books', function(Blueprint $table) {
			$table->dropForeign('books_pub_house_id_foreign');
		});
		Schema::table('books', function(Blueprint $table) {
			$table->dropForeign('books_auther_id_foreign');
		});
		Schema::table('books', function(Blueprint $table) {
			$table->dropForeign('books_category_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_branch_id_foreign');
		});
		Schema::table('cupboards', function(Blueprint $table) {
			$table->dropForeign('cupboards_room_id_foreign');
		});
		Schema::table('shelves', function(Blueprint $table) {
			$table->dropForeign('shelves_cupboard_id_foreign');
		});
		Schema::table('book_copies', function(Blueprint $table) {
			$table->dropForeign('book_copies_author_id_foreign');
		});
		Schema::table('book_copies', function(Blueprint $table) {
			$table->dropForeign('book_copies_pub_house_id_foreign');
		});
		Schema::table('book_copies', function(Blueprint $table) {
			$table->dropForeign('book_copies_category_id_foreign');
		});
	}
}