<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampusTable extends Migration {

	public function up()
	{
		Schema::create('campus', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_escuela')->unsigned();
			$table->string('campus', 255);
			$table->string('director', 255);
			$table->integer('id_estado');
			$table->integer('id_municipio')->unsigned();
			$table->integer('id_localidad')->unsigned();
			$table->string('colonia', 255);
			$table->string('domicilio', 255);
			$table->string('numero', 5);
			$table->string('cp', 6);
			$table->string('telefono', 15);
			$table->string('fax', 15);
			$table->string('email', 180);
			$table->string('latitud', 20);
			$table->string('longitud');
			$table->integer('id_status')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('campus');
	}
}