<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocentesTable extends Migration {

	public function up()
	{
		Schema::create('docentes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('tipo_docente')->unsigned();
			$table->string('curp', 20);
			$table->string('rfc', 10);
			$table->string('nombres', 120);
			$table->string('paterno', 120);
			$table->string('materno', 120);
			$table->date('fecha_nacimiento');
			$table->integer('id_estado');
			$table->integer('id_municipio')->unsigned();
			$table->integer('id_localidad')->unsigned();
			$table->string('colonia', 255);
			$table->string('domicilio');
			$table->string('numero', 5);
			$table->string('cp', 6);
			$table->string('telefono', 15);
			$table->string('email', 120);
			$table->integer('id_status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('docentes');
	}
}