<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('user_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('user_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->foreign('municipio')->references('Id_Municipio')->on('municipios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->foreign('localidad')->references('Id_Localidad')->on('localidades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->foreign('serreg')->references('Id_Regional')->on('regionales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->foreign('status')->references('Status')->on('estatus_de_cct')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->foreign('Id_Tipo_Nivel')->references('Id_Tipo_Nivel')->on('tipo_nivel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->foreign('Id_Nivel')->references('Id_Nivel')->on('niveles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->foreign('Id_SubNivel')->references('Id_Subnivel')->on('subniveles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('niveles', function(Blueprint $table) {
			$table->foreign('Id_Tipo_Nivel')->references('Id_Tipo_Nivel')->on('tipo_nivel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subniveles', function(Blueprint $table) {
			$table->foreign('Id_Tipo_Nivel')->references('Id_Tipo_Nivel')->on('tipo_nivel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subniveles', function(Blueprint $table) {
			$table->foreign('Id_Nivel')->references('Id_Nivel')->on('niveles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('turnos_de_cct', function(Blueprint $table) {
			$table->foreign('Id_Turno')->references('Id_Turno')->on('turnos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('regionales', function(Blueprint $table) {
			$table->foreign('Id_Region')->references('Id_Region')->on('regiones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('escuelas', function(Blueprint $table) {
			$table->foreign('id_estatus')->references('id')->on('estatus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campus', function(Blueprint $table) {
			$table->foreign('id_escuela')->references('id')->on('escuelas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campus', function(Blueprint $table) {
			$table->foreign('id_municipio')->references('Id_Municipio')->on('municipios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campus', function(Blueprint $table) {
			$table->foreign('id_localidad')->references('Id_Localidad')->on('localidades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campus', function(Blueprint $table) {
			$table->foreign('id_status')->references('id')->on('estatus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carreras', function(Blueprint $table) {
			$table->foreign('id_campus')->references('id')->on('campus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->foreign('id_escuela')->references('id')->on('escuelas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->foreign('id_carrera')->references('id')->on('carreras')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->foreign('id_subnivel')->references('Id_Subnivel')->on('subniveles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->foreign('id_nivel')->references('Id_Nivel')->on('niveles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->foreign('id_modalidad')->references('id')->on('modalidades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->foreign('id_opcion')->references('id')->on('opciones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->foreign('id_plan')->references('id')->on('planes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->foreign('id_turno')->references('Id_Turno')->on('turnos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->foreign('id_tipo_alumnado')->references('id')->on('tipo_alumnado')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('curriculas', function(Blueprint $table) {
			$table->foreign('id_programa')->references('id')->on('programas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('curriculas', function(Blueprint $table) {
			$table->foreign('id_grado')->references('id')->on('grados')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('curriculas', function(Blueprint $table) {
			$table->foreign('id_asignatura')->references('id')->on('asignaturas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('curriculas', function(Blueprint $table) {
			$table->foreign('id_componente')->references('id')->on('componentes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('curriculas', function(Blueprint $table) {
			$table->foreign('asignatura_previa')->references('id')->on('asignaturas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('docentes', function(Blueprint $table) {
			$table->foreign('tipo_docente')->references('id')->on('tipo_docentes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('docentes', function(Blueprint $table) {
			$table->foreign('id_municipio')->references('Id_Municipio')->on('municipios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('docentes', function(Blueprint $table) {
			$table->foreign('id_localidad')->references('Id_Localidad')->on('localidades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('grados_grupos', function(Blueprint $table) {
			$table->foreign('id_grado')->references('id')->on('grados')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('grados_grupos', function(Blueprint $table) {
			$table->foreign('id_grupo')->references('id')->on('grupos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('aulas', function(Blueprint $table) {
			$table->foreign('id_edificio')->references('id')->on('edificios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->foreign('id_programa')->references('id')->on('programas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->foreign('id_ciclo')->references('id_ciclo')->on('ciclos_escolares')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->foreign('id_status')->references('id')->on('estatus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alumnos', function(Blueprint $table) {
			$table->foreign('id_municipio')->references('Id_Municipio')->on('municipios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alumnos', function(Blueprint $table) {
			$table->foreign('id_localidad')->references('Id_Localidad')->on('localidades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('kardex', function(Blueprint $table) {
			$table->foreign('id_alumno')->references('id')->on('alumnos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('kardex', function(Blueprint $table) {
			$table->foreign('id_curso')->references('id')->on('cursos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->foreign('id_curso')->references('id')->on('cursos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->foreign('id_grado')->references('id')->on('grados')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->foreign('id_grupo')->references('id')->on('grupos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->foreign('id_aula')->references('id')->on('aulas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->foreign('id_asignatura')->references('id')->on('asignaturas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->foreign('id_docente')->references('id')->on('docentes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('preinscripciones', function(Blueprint $table) {
			$table->foreign('id_alumno')->references('id')->on('alumnos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('preinscripciones', function(Blueprint $table) {
			$table->foreign('id_curso')->references('id')->on('cursos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inscripciones', function(Blueprint $table) {
			$table->foreign('id_alumno')->references('id')->on('alumnos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inscripciones', function(Blueprint $table) {
			$table->foreign('id_curso')->references('id')->on('cursos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inscripciones', function(Blueprint $table) {
			$table->foreign('id_ciclo')->references('id_ciclo')->on('ciclos_escolares')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inscripciones', function(Blueprint $table) {
			$table->foreign('id_grado')->references('id')->on('grados')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inventario', function(Blueprint $table) {
			$table->foreign('id_tipo_bien')->references('id')->on('tipo_bienes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prestamo_acervos', function(Blueprint $table) {
			$table->foreign('id_acervo')->references('id')->on('acervos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prestamo_acervos', function(Blueprint $table) {
			$table->foreign('id_alumno')->references('id')->on('alumnos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('credenciales', function(Blueprint $table) {
			$table->foreign('id_alumno')->references('id')->on('alumnos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('credenciales', function(Blueprint $table) {
			$table->foreign('id_periodo')->references('id')->on('periodos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultas_medicas', function(Blueprint $table) {
			$table->foreign('id_alumno')->references('id')->on('alumnos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('constancias', function(Blueprint $table) {
			$table->foreign('id_alumno')->references('id')->on('alumnos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('constancias', function(Blueprint $table) {
			$table->foreign('id_tipo_constancia')->references('id')->on('tipo_constancias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('logs', function(Blueprint $table) {
			$table->dropForeign('logs_user_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_type_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_status_id_foreign');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->dropForeign('user_permissions_user_id_foreign');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->dropForeign('user_permissions_module_id_foreign');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->dropForeign('centros_de_trabajo_municipio_foreign');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->dropForeign('centros_de_trabajo_localidad_foreign');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->dropForeign('centros_de_trabajo_serreg_foreign');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->dropForeign('centros_de_trabajo_status_foreign');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->dropForeign('centros_de_trabajo_Id_Tipo_Nivel_foreign');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->dropForeign('centros_de_trabajo_Id_Nivel_foreign');
		});
		Schema::table('centros_de_trabajo', function(Blueprint $table) {
			$table->dropForeign('centros_de_trabajo_Id_SubNivel_foreign');
		});
		Schema::table('niveles', function(Blueprint $table) {
			$table->dropForeign('niveles_Id_Tipo_Nivel_foreign');
		});
		Schema::table('subniveles', function(Blueprint $table) {
			$table->dropForeign('subniveles_Id_Tipo_Nivel_foreign');
		});
		Schema::table('subniveles', function(Blueprint $table) {
			$table->dropForeign('subniveles_Id_Nivel_foreign');
		});
		Schema::table('turnos_de_cct', function(Blueprint $table) {
			$table->dropForeign('turnos_de_cct_Id_Turno_foreign');
		});
		Schema::table('regionales', function(Blueprint $table) {
			$table->dropForeign('regionales_Id_Region_foreign');
		});
		Schema::table('escuelas', function(Blueprint $table) {
			$table->dropForeign('escuelas_id_estatus_foreign');
		});
		Schema::table('campus', function(Blueprint $table) {
			$table->dropForeign('campus_id_escuela_foreign');
		});
		Schema::table('campus', function(Blueprint $table) {
			$table->dropForeign('campus_id_municipio_foreign');
		});
		Schema::table('campus', function(Blueprint $table) {
			$table->dropForeign('campus_id_localidad_foreign');
		});
		Schema::table('campus', function(Blueprint $table) {
			$table->dropForeign('campus_id_status_foreign');
		});
		Schema::table('carreras', function(Blueprint $table) {
			$table->dropForeign('carreras_id_campus_foreign');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->dropForeign('programas_id_escuela_foreign');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->dropForeign('programas_id_carrera_foreign');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->dropForeign('programas_id_subnivel_foreign');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->dropForeign('programas_id_nivel_foreign');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->dropForeign('programas_id_modalidad_foreign');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->dropForeign('programas_id_opcion_foreign');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->dropForeign('programas_id_plan_foreign');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->dropForeign('programas_id_turno_foreign');
		});
		Schema::table('programas', function(Blueprint $table) {
			$table->dropForeign('programas_id_tipo_alumnado_foreign');
		});
		Schema::table('curriculas', function(Blueprint $table) {
			$table->dropForeign('curriculas_id_programa_foreign');
		});
		Schema::table('curriculas', function(Blueprint $table) {
			$table->dropForeign('curriculas_id_grado_foreign');
		});
		Schema::table('curriculas', function(Blueprint $table) {
			$table->dropForeign('curriculas_id_asignatura_foreign');
		});
		Schema::table('curriculas', function(Blueprint $table) {
			$table->dropForeign('curriculas_id_componente_foreign');
		});
		Schema::table('curriculas', function(Blueprint $table) {
			$table->dropForeign('curriculas_asignatura_previa_foreign');
		});
		Schema::table('docentes', function(Blueprint $table) {
			$table->dropForeign('docentes_tipo_docente_foreign');
		});
		Schema::table('docentes', function(Blueprint $table) {
			$table->dropForeign('docentes_id_municipio_foreign');
		});
		Schema::table('docentes', function(Blueprint $table) {
			$table->dropForeign('docentes_id_localidad_foreign');
		});
		Schema::table('grados_grupos', function(Blueprint $table) {
			$table->dropForeign('grados_grupos_id_grado_foreign');
		});
		Schema::table('grados_grupos', function(Blueprint $table) {
			$table->dropForeign('grados_grupos_id_grupo_foreign');
		});
		Schema::table('aulas', function(Blueprint $table) {
			$table->dropForeign('aulas_id_edificio_foreign');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->dropForeign('cursos_id_programa_foreign');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->dropForeign('cursos_id_ciclo_foreign');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->dropForeign('cursos_id_status_foreign');
		});
		Schema::table('alumnos', function(Blueprint $table) {
			$table->dropForeign('alumnos_id_municipio_foreign');
		});
		Schema::table('alumnos', function(Blueprint $table) {
			$table->dropForeign('alumnos_id_localidad_foreign');
		});
		Schema::table('kardex', function(Blueprint $table) {
			$table->dropForeign('kardex_id_alumno_foreign');
		});
		Schema::table('kardex', function(Blueprint $table) {
			$table->dropForeign('kardex_id_curso_foreign');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->dropForeign('horarios_id_curso_foreign');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->dropForeign('horarios_id_grado_foreign');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->dropForeign('horarios_id_grupo_foreign');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->dropForeign('horarios_id_aula_foreign');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->dropForeign('horarios_id_asignatura_foreign');
		});
		Schema::table('horarios', function(Blueprint $table) {
			$table->dropForeign('horarios_id_docente_foreign');
		});
		Schema::table('preinscripciones', function(Blueprint $table) {
			$table->dropForeign('preinscripciones_id_alumno_foreign');
		});
		Schema::table('preinscripciones', function(Blueprint $table) {
			$table->dropForeign('preinscripciones_id_curso_foreign');
		});
		Schema::table('inscripciones', function(Blueprint $table) {
			$table->dropForeign('inscripciones_id_alumno_foreign');
		});
		Schema::table('inscripciones', function(Blueprint $table) {
			$table->dropForeign('inscripciones_id_curso_foreign');
		});
		Schema::table('inscripciones', function(Blueprint $table) {
			$table->dropForeign('inscripciones_id_ciclo_foreign');
		});
		Schema::table('inscripciones', function(Blueprint $table) {
			$table->dropForeign('inscripciones_id_grado_foreign');
		});
		Schema::table('inventario', function(Blueprint $table) {
			$table->dropForeign('inventario_id_tipo_bien_foreign');
		});
		Schema::table('prestamo_acervos', function(Blueprint $table) {
			$table->dropForeign('prestamo_acervos_id_acervo_foreign');
		});
		Schema::table('prestamo_acervos', function(Blueprint $table) {
			$table->dropForeign('prestamo_acervos_id_alumno_foreign');
		});
		Schema::table('credenciales', function(Blueprint $table) {
			$table->dropForeign('credenciales_id_alumno_foreign');
		});
		Schema::table('credenciales', function(Blueprint $table) {
			$table->dropForeign('credenciales_id_periodo_foreign');
		});
		Schema::table('consultas_medicas', function(Blueprint $table) {
			$table->dropForeign('consultas_medicas_id_alumno_foreign');
		});
		Schema::table('constancias', function(Blueprint $table) {
			$table->dropForeign('constancias_id_alumno_foreign');
		});
		Schema::table('constancias', function(Blueprint $table) {
			$table->dropForeign('constancias_id_tipo_constancia_foreign');
		});
	}
}