<?php

namespace App\models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Property extends Eloquent {

	protected $table = 'properties';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function protfolio()
	{
		return $this->belongsTo('App\models\Protfolio');
	}

	public function services()
	{
		return $this->hasMany('App\models\PropertyService');
	}

}