<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProjectContractor extends Eloquent {

	protected $table = 'project_contractor';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'contractor_id');

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function contractor()
	{
		return $this->belongsTo('Contractor', 'contractor_id');
	}

}