<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerAddressTable extends Migration {

	public function up()
	{
		Schema::create('customer_address', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->mediumText('address')->nullable()->index();
			$table->integer('city_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->integer('country_id')->unsigned()->index();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customer_address');
	}
}