<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerTable extends Migration {

	public function up()
	{
		Schema::create('customer', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255)->index();
			$table->string('middle_name', 255);
			$table->string('last_name', 255)->index();
			$table->timestamps();
			$table->softDeletes();
			$table->date('dob')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('customer');
	}
}