<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoanerThresholdCriteriaTable extends Migration {

	public function up()
	{
		Schema::create('loaner_threshold_criteria', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('loaner_vehicle_id')->unsigned();
			$table->integer('mileage')->index()->default('0');
			$table->smallInteger('number_yrs_from_manufacturing')->index()->default('0');
			$table->date('manufacture_year')->index();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('loaner_threshold_criteria');
	}
}