<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehicleInsuranceInfoTable extends Migration {

	public function up()
	{
		Schema::create('vehicle_insurance_info', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->index();
			$table->integer('insurance_company_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->string('policy_number', 255)->index();
			$table->datetime('policy_expiry_date')->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('vehicle_insurance_info');
	}
}