<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoanerVehicleInventoryLogTable extends Migration {

	public function up()
	{
		Schema::create('loaner_vehicle_inventory_log', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('loaner_vehicle_inventory_id')->unsigned();
			$table->integer('loaner_vehicle_id')->unsigned();
			$table->string('vin', 255)->index();
			$table->string('exterior_color', 255)->nullable();
			$table->string('interior_color', 255)->nullable();
			$table->string('license_plate_number', 255)->index();
			$table->string('license_plate_state', 255);
			$table->string('plate_expiry_date', 255)->index();
			$table->integer('odometer_reading')->index()->default('0');
			$table->float('tank_size')->index()->default('0');
			$table->integer('transmission_type_id')->unsigned();
			$table->text('loaner_vehicle_images');
			$table->integer('current_status')->unsigned();
			$table->text('car_images')->nullable();
			$table->integer('created_by')->unsigned();
			$table->datetime('created_date');
			$table->integer('modified_by')->unsigned();
			$table->datetime('modified_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('loaner_vehicle_inventory_log');
	}
}