<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->string('uuid')->primary();
			$table->string('name', 256);
			$table->string('function_space')->nullable();
			$table->string('address');
			$table->string('address_2')->nullable();
			$table->string('city', 128);
			$table->string('state');
			$table->string('country');
			$table->string('postal_code', 16);
			$table->string('longitude');
			$table->string('latitude')->nullable();
			$table->json('data')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}