<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('level', 'password', 'email', 'first_name', 'last_name', 'hierarchy');
	protected $hidden = array('password');

	public function products()
	{
		return $this->hasMany('app\Product');
	}

}