<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('iso2');
			$table->string('logo_url')->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->text('featured_image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}