<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->uuid('uuid')->primary()->index();
			$table->uuid('uuid_user');
			$table->date('dob')->nullable();
			$table->string('sex', 10)->nullable();
			$table->text('about')->nullable();
			$table->integer('status')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}