<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Plans extends Eloquent {

	protected $table = 'plans';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('price_monthly', 'price_yearly');
	protected $visible = array('price_monthly', 'price_yearly');

	public function features()
	{
		return $this->hasManyThrough('Features', 'PlansFeatures');
	}

}