<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Reviews extends Eloquent {

	protected $table = 'reviews';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('patient_id', 'therapist_id', 'text', 'rate_count');
	protected $visible = array('text', 'rate_count');

	public function therapist()
	{
		return $this->hasOne('Users', 'therapist_id', 'id');
	}

	public function patient()
	{
		return $this->hasOne('Users')patient_id, id;
	}

}