<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BankAccounts extends Model 
{

    protected $table = 'bank_accounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('beneficiary_name', 'iban', 'bank_account_number', 'swift_code', 'user_id');
    protected $visible = array('beneficiary_name', 'iban', 'bank_account_number', 'swift_code');

    public function owner()
    {
        return $this->belongsTo('Users', 'user_id', 'id');
    }

}