<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('dt_id', 100)->unique();
			$table->string('name', 255);
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->integer('role_id')->unsigned();
			$table->string('telephone', 255);
			$table->string('address', 255);
			$table->string('city', 255);
			$table->string('country', 255);
			$table->string('postal_code')->nullable();
			$table->string('website', 255)->nullable();
			$table->date('birth_date')->nullable();
			$table->boolean('active')->default(1);
			$table->string('email_verified_at');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('location_type_id')->unsigned();
			$table->decimal('wallet_amount', 8,2);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}