<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTherapyTypesTable extends Migration {

	public function up()
	{
		Schema::create('therapy_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('slug', 255)->unique();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('created_by')->unsigned();
			$table->boolean('active')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('therapy_types');
	}
}